﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUsersLogin : BaseAPIMethod
        {

            public MethodUsersLogin(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "userslogin"; }
            }

            private string _email = null;
            private string _pass = null;
            protected override void DoReadRequestParams()
            {
                _email = Component.APIRequestParams["email"];
                _pass = Component.APIRequestParams["pass"];
            }

            /// <summary>
            /// Tutaj musimy nadpisac walidacje bazowa, bo nie ma jeszcze sesji
            /// wiec sprawdzamy tylko czy sa parametry w URLu wlasciwe
            /// </summary>
            /// <returns></returns>
            protected override bool IsValid()
            {
                return DoValidate();
            }

            protected override bool DoValidate()
            {
                if (!string.IsNullOrEmpty(_email) && !string.IsNullOrEmpty(_pass))
                {
                    return true;
                }
                AddErrorMessage("Nie podano login lub hasło.");
                StatusCode = StatusCodeType.BadRequest;
                return false;
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (Component.Environment.Login(_email, _pass) && Component.Environment.SessionManager != null && Component.Environment.SessionManager.Current != null)
                {
                    string _sessionID = Component.Environment.SessionManager.Current.UID;
                    GUsersView _GUser = Component.BLELearning.APIMobile.GetGUser(Component.Environment.User);
                    if (_GUser != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_User() { session_id = Component.Environment.SessionManager.Current.UID, User = _GUser };
                    }
                    else
                    {
                        AddErrorMessage("Niepoprawny login lub hasło. Brak użytkownika.");
                        StatusCode = StatusCodeType.Unauthorized;
                    }
                }
                else
                {
                    AddErrorMessage("Niepoprawny login lub hasło. Błąd logowania.");
                    StatusCode = StatusCodeType.Unauthorized;
                }
                return null;
            }

        }
    }
}